/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractComparableIterator<T>
implements Comparable<AbstractComparableIterator<T>>,
Iterator<T> {
    private T next;
    private Comparator<T> comparator;

    public AbstractComparableIterator() {
        this.comparator = null;
    }

    public AbstractComparableIterator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    @Override
    public boolean hasNext() {
        return this.getNext() != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public T getNext() {
        return this.next;
    }

    protected void setNext(T next) {
        this.next = next;
    }

    protected abstract void prepareNext();

    @Override
    public T next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        T result = this.next;
        this.prepareNext();
        return result;
    }

    @Override
    public int compareTo(AbstractComparableIterator<T> o) {
        int res;
        if (this == o) {
            return 0;
        }
        if (this.comparator != null) {
            res = this.comparator.compare(this.getNext(), o.getNext());
        } else if (this.getNext() instanceof Comparable) {
            res = ((Comparable)this.getNext()).compareTo(o.getNext());
        } else {
            throw new IllegalStateException("Iterators cannot be compared.");
        }
        if (res == 0) {
            return this.hashCode() < o.hashCode() ? -1 : 1;
        }
        return res;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

